/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!***************************************************!*\
  !*** ./resources/js/design_1/parts/show_event.js ***!
  \***************************************************/
(function ($) {
  "use strict";

  $(document).ready(function () {
    var eventCountdownTime = $('#eventCountdownTime');
    if (eventCountdownTime.length) {
      var endtimeDate = eventCountdownTime.attr('data-day');
      var endtimeHours = eventCountdownTime.attr('data-hour');
      var endtimeMinutes = eventCountdownTime.attr('data-minute');
      //var endtimeSeconds = eventCountdownTime.attr('data-second');

      eventCountdownTime.countdown100({
        endtimeYear: 0,
        endtimeMonth: 0,
        endtimeDate: endtimeDate,
        endtimeHours: endtimeHours,
        endtimeMinutes: endtimeMinutes,
        //endtimeSeconds: endtimeSeconds,
        timeZone: ""
      });
    }

    /* Bottom Fixed */
    var $bottomFixedCard = $('.event-bottom-fixed-card');
    var $bottomFixedProgress = $('.event-bottom-fixed-card__progress');
    $(document).scroll(function () {
      var scrollTop = $(this).scrollTop();
      if (scrollTop > 500) {
        $bottomFixedCard.addClass('show');
      } else {
        $bottomFixedCard.removeClass('show');
      }
      updateProgressBar();
    });
    function updateProgressBar() {
      var scrollTop = $(window).scrollTop();
      var scrollHeight = $(document).height();
      var clientHeight = $(window).height();

      // Calculate the scroll percentage
      var scrollPercentage = scrollTop / (scrollHeight - clientHeight) * 100;

      // Update the width of the progress bar
      $bottomFixedProgress.find('.progress-line').css('width', scrollPercentage + '%');
    }
  });

  /**
   * Bottom Actions
   * */
  $('body').on('click', '.js-scroll-to-event-tickets-btn', function (e) {
    e.preventDefault();
    var $toggleTab = $('#showEventAboutTab');
    $toggleTab.trigger('click');
    var $container = $('#eventTicketsContainer');
    $('html, body').animate({
      scrollTop: $container.offset().top - 150
    }, 500);
  });

  /**
   * Share Modal
   * */
  $('body').on('click', '.js-share-event', function (e) {
    e.preventDefault();
    var path = $(this).attr("data-path");
    handleBasicModal(path, shareLang, function (result, $body, $footer) {
      $footer.addClass('d-none');
    }, '', '40rem');
  });

  /**
   * Report Modal
   * */
  $('body').on('click', '.js-report-event', function (e) {
    e.preventDefault();
    var path = $(this).attr("data-path");
    handleBasicModal(path, reportEventLang, function (result, $body, $footer) {
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-end\">\n                <button type=\"button\" class=\"js-submit-event-report btn btn-primary\">".concat(reportLang, "</button>\n            </div>");
      $footer.html(footerHtml);
    }, '', '40rem');
  });
  $('body').on('click', '.js-submit-event-report', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('.js-custom-modal').find('.js-event-report-form');
    var path = $form.attr("action");
    handleSendRequestItemForm($form, $this, path);
  });

  /*===========
  | Quantity
  * *********/
  function handleQuantityValue($btn, type) {
    var $card = $btn.closest('.js-event-quantity-card');
    var $input = $card.find('input[name="quantity"]');
    var eventAvailabilityCount = $card.find('.js-event-availability-count').val();
    var value = $input.val();
    if (type === 'minus' && value > 1) {
      value = Number(value) - 1;
    } else if (type === 'plus') {
      value = Number(value) + 1;
    }
    if (!isNaN(eventAvailabilityCount) && value > Number(eventAvailabilityCount)) {
      value = Number(eventAvailabilityCount);
    }
    $input.val(value);
  }
  $('body').on('click', '.js-event-quantity-card .minus', function (e) {
    e.preventDefault();
    var $this = $(this);
    handleQuantityValue($this, 'minus');
  });
  $('body').on('click', '.js-event-quantity-card .plus', function (e) {
    e.preventDefault();
    var $this = $(this);
    handleQuantityValue($this, 'plus');
  });

  /**/
  $('body').on('click', '.js-view-more-reviews', function (e) {
    e.preventDefault();
    var $toggleTab = $('#showEventReviewsTab');
    $('html, body').animate({
      scrollTop: $toggleTab.offset().top - 150
    }, 1000, function () {
      $toggleTab.trigger('click');
    });
  });

  /********
   *  Add To Cart
   * */
  $('body').on('click', '.js-event-ticket-add-to-cart', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('.js-event-ticket-add-to-cart-form');
    var path = "/cart/store";
    handleSendRequestItemForm($form, $this, path);
  });

  /********
   *  Free Ticket
   * */
  $('body').on('click', '.js-event-get-free-ticket-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('.js-event-ticket-add-to-cart-form');
    var path = $this.attr('data-path');
    handleSendRequestItemForm($form, $this, path);
  });

  /**
   * event demo modal
   * */
  var courseDemoVideoPlayer;
  $('body').on('click', '#eventDemoVideoBtn', function (e) {
    e.preventDefault();
    if (courseDemoVideoPlayer !== undefined) {
      courseDemoVideoPlayer.stop();
    }
    var path = $(this).attr('data-video-path');
    var source = $(this).attr('data-video-source');
    var thumbnail = $(this).attr('data-thumbnail');
    var height = $(window).width() > 991 ? 480 : 264;
    var videoTagId = 'demoVideoPlayer';
    var _makeVideoPlayerHtml = makeVideoPlayerHtml(path, source, height, videoTagId, thumbnail),
      html = _makeVideoPlayerHtml.html,
      options = _makeVideoPlayerHtml.options;

    /*const footer = `<div class="d-flex align-items-center justify-content-end">
            <button type="button" class="close-swl btn btn-transparent mr-16">${closeLang}</button>
    </div>`;*/

    var body = makeModalHtml(eventDemoLang, closeIcon, html, '&nbsp;');
    Swal.fire({
      html: body,
      showCancelButton: false,
      showConfirmButton: false,
      width: '48rem',
      didOpen: function didOpen() {
        var $videoTagEl = $("#".concat(videoTagId));
        if ($videoTagEl.length) {
          courseDemoVideoPlayer = new Plyr("#".concat(videoTagId), options);
        }
      }
    });
  });
})(jQuery);
/******/ })()
;