/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!******************************************************!*\
  !*** ./resources/js/design_1/parts/learning_page.js ***!
  \******************************************************/
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return _typeof(key) === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (_typeof(input) !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (_typeof(res) !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function ($) {
  "use strict";

  var $mainContent = $('#mainContent');
  $(document).ready(function () {
    handleDefaultItemLoaded();
    handleTrackSpentTime();
  });
  function handleTrackSpentTime() {
    var path = "".concat(courseLearningUrl, "/track-time");
    setInterval(function () {
      $.post(path, {}, function (result) {
        if (result && result.force_reload) {
          window.location.reload();
        }
      });
    }, 10000);
  }
  function contentEmptyStateHtml() {
    var html = "<div class=\"bg-white rounded-24 p-16\">\n            <div class=\"d-flex-center flex-column text-center border-gray-200 rounded-12 py-160\">\n                <div class=\"\">\n                    <img src=\"/assets/design_1/img/courses/learning_page/empty_state.svg\" alt=\"\" class=\"img-fluid\" width=\"285px\" height=\"212px\">\n                </div>\n\n                <h3 class=\"mt-12 font-16\">".concat(learningPageEmptyContentTitleLang, "</h3>\n                <div class=\"mt-8 text-gray-500\">").concat(learningPageEmptyContentHintLang, "</div>\n            </div>\n        </div>");
    $mainContent.html(html);
  }
  function handleDefaultItemLoaded() {
    var allItems = $('.js-content-tab-item');
    if (allItems && allItems.length && defaultItemType && defaultItemType !== '' && defaultItemId && defaultItemId !== '') {
      var _iterator = _createForOfIteratorHelper(allItems),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var item = _step.value;
          var $item = $(item);
          var type = $item.attr('data-type');
          var id = $item.attr('data-id');
          if (type === defaultItemType && id === defaultItemId) {
            $item.trigger('click');
            activeAccordionByItem($item);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    } else if (allItems && loadFirstContent && loadFirstContent !== 'false') {
      if (allItems.length) {
        var _item = allItems[0];
        var _$item = $(_item);
        _$item.trigger('click');
        activeAccordionByItem(_$item);
      } else {
        contentEmptyStateHtml();
      }
    }
  }
  function activeAccordionByItem($item) {
    var $accordion = $item.closest('.js-accordion-parent');
    if ($accordion.length) {
      var $btn = $accordion.find('.js-accordion-collapse-arrow');
      $btn.trigger('click');
      var $scroller = $('#learningPageSidebar .simplebar-content-wrapper');
      setTimeout(function () {
        $scroller.animate({
          scrollTop: $item.offset().top - 200
        }, 500);
      }, 1500);
    }
  }
  function handleLoadingHtml() {
    var html = "<div class=\"bg-white rounded-24 p-16\">\n            <div class=\"d-flex-center flex-column text-center border-gray-200 rounded-12 py-160\">\n                <div class=\"\">\n                    <img src=\"/assets/default/img/loading.svg\" alt=\"\" class=\"img-fluid\" width=\"80px\" height=\"80px\">\n                </div>\n\n                <h3 class=\"mt-12 font-16\">".concat(pleaseWaitLang, "</h3>\n                <div class=\"mt-8 text-gray-500\">").concat(pleaseWaitForTheContentLang, "</div>\n            </div>\n        </div>");
    $mainContent.html(html);
  }
  function addItemToUrlBar(itemId, itemType) {
    var extraData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var currentPath = window.location.pathname;
    var newPath = currentPath.replace('/forum', ''); // when i forum page

    var params = new URLSearchParams();
    params.set('type', itemType);
    params.set('item', itemId);
    if (extraData) {
      for (var key in extraData) {
        params.set(key, extraData[key]);
      }
    }
    window.history.pushState({}, '', "".concat(newPath, "?").concat(params.toString()));
  }
  function handleVideoPlayer() {
    var $players = $('.js-file-player-el');
    if ($players.length) {
      var _iterator2 = _createForOfIteratorHelper($players),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var plyr = _step2.value;
          var player = new Plyr(plyr);

          // Attach moving watermark after player ready
          if (typeof window.initMovingWatermark === 'function' && typeof window.wmUserName !== 'undefined' && window.wmEnabled !== false) {
            try {
              window.initMovingWatermark(player, {
                userName: window.wmUserName,
                avatarUrl: window.wmUserAvatar,
                mode: window.wmMode || 'fade',
                opacity: typeof window.wmOpacity !== 'undefined' ? window.wmOpacity : undefined,
                size: window.wmSize || '1',
                data: window.wmData || 'student'
              });
            } catch (e) {}
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }
  function handleContentItemHtml(itemId, itemType) {
    var extraData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var path = "/course/learning/".concat(courseSlug, "/itemInfo");
    var data = _objectSpread({
      id: itemId,
      type: itemType
    }, extraData);
    $.post(path, data, function (result) {
      if (result.code === 200) {
        $mainContent.html(result.html);
        tippyTooltip();
        handleVideoPlayer();
      }
    }).fail(function (err) {
      showToast('error', oopsLang, somethingWentWrongLang);
    });
    addItemToUrlBar(itemId, itemType, extraData);
  }
  $('body').on('click', '.js-content-tab-item', function (e) {
    var $this = $(this);
    if (!$this.hasClass('active')) {
      var _$this$attr, _$this$attr2;
      var type = $this.attr('data-type');
      var id = $this.attr('data-id');
      var extraKey = (_$this$attr = $this.attr('data-extra-key')) !== null && _$this$attr !== void 0 ? _$this$attr : null;
      var extraValue = (_$this$attr2 = $this.attr('data-extra-value')) !== null && _$this$attr2 !== void 0 ? _$this$attr2 : null;
      var extraData = {};
      if (extraKey && extraValue) {
        extraData[extraKey] = extraValue;
      }
      $('.js-content-tab-item').removeClass('active');
      $this.addClass('active');
      $('#learningPageSidebar').removeClass('show-drawer');
      if (!$this.hasClass('js-sequence-content-error-modal')) {
        handleLoadingHtml();
        handleContentItemHtml(id, type, extraData);
      }
    }
  });
  $('body').on('click', '.js-learning-file-video-player-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $el = $this.closest('.js-learning-file-video-player-box');
    var fileId = $this.attr('data-id');
    handleVideoByFileId(fileId, $el, function () {});
  });

  /**
   * I Passed Item Toggle
   * */
  $('body').on('change', '.js-passed-item-toggle', function (e) {
    var $this = $(this);
    var courseSlug = $this.attr("data-course-slug");
    var item = $this.attr("data-item-name");
    var itemId = $this.val();
    var status = this.checked;
    var path = "/course/".concat(courseSlug, "/learningStatus");
    var data = {
      item: item,
      item_id: itemId,
      status: status
    };
    var $percentBar = $('.js-course-learning-progress-bar-percent');
    var $percentNum = $('.js-course-learning-progress-percent');
    $.post(path, data, function (result) {
      showToast("success", result.title, result.msg);
      if (result.learning_progress_percent && $percentBar.length) {
        $percentBar.css('width', result.learning_progress_percent + '%');
        $percentNum.text("".concat(result.learning_progress_percent, "%"));
      }
      if (result.learning_progress_percent && result.learning_progress_percent >= 100) {
        handleCourseCompletedModal();
      }
    }).fail(function (err) {
      $this.prop('checked', !status);
      showToast('error', oopsLang, somethingWentWrongLang);
    });
  });
  function handleCourseCompletedModal() {
    var path = "/course/".concat(courseSlug, "/learning-status-completed-modal");
    handleBasicModal(path, courseCompletedLang, function (result, $body, $footer) {
      $footer.remove();
    }, '', '37rem');
  }

  /******
   * Personal Note
   * ****/
  $('body').on('click', '.js-add-personal-note', function (e) {
    e.preventDefault();
    var $this = $(this);
    var itemType = $this.attr('data-item-type');
    var itemId = $this.attr('data-item-id');
    var path = "".concat(courseLearningUrl, "/personal-note/get-form?item_id=").concat(itemId, "&item_type=").concat(itemType);
    handleBasicModal(path, newCourseNoteLang, function (result, $body, $footer) {
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-end mt-25\">\n                <button type=\"button\" class=\"js-save-personal-note btn btn-primary\">".concat(saveNoteLang, "</button>\n            </div>");
      $footer.html(footerHtml);
    }, '', '42rem');
  });
  $('body').on('click', '.js-save-personal-note', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $('.js-personal-note-form');
    var path = $form.attr('data-action');
    handleSendRequestItemForm($form, $this, path);
  });
  $('body').on('click', '.js-edit-personal-note', function (e) {
    e.preventDefault();
    var $this = $(this);
    var itemType = $this.attr('data-item-type');
    var itemId = $this.attr('data-item-id');
    var path = "".concat(courseLearningUrl, "/personal-note/get-details?item_id=").concat(itemId, "&item_type=").concat(itemType);
    handleBasicModal(path, courseNoteLang, function (result, $body, $footer) {
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-between\">\n                        <div class=\"\">\n                            <span class=\"d-block font-12 text-gray-500\">".concat(submittedOnLang, "</span>\n                            <span class=\"d-block font-12 text-gray-500 font-weight-bold mt-2\">").concat(result.submitted_on, "</span>\n                        </div>\n\n                        <div class=\"d-flex align-items-center gap-24\">\n                            <a href=\"/course/personal-notes/").concat(result.note_id, "/delete\" class=\"delete-action text-danger\">").concat(deleteNoteLang, "</a>\n\n                            <button type=\"button\" class=\"js-add-personal-note btn btn-primary\"\n                                    data-item-id=\"").concat(result.item_id, "\"\n                                    data-item-type=\"").concat(result.item_type, "\"\n                            >").concat(editLang, "</button>\n                        </div>\n                    </div>");
      $footer.html(footerHtml);
    }, '', '42rem');
  });

  /************
   * Session
   *
   * */
  $('body').on('click', '.js-check-again-session', function (e) {
    e.preventDefault();
    var $this = $(this);
    var itemId = $this.attr('data-id');
    var itemType = "session";
    handleLoadingHtml();
    handleContentItemHtml(itemId, itemType);
  });

  /************
   * Sequence Content
   * */
  $('body').on('click', '.js-sequence-content-error-modal', function (e) {
    e.preventDefault();
    var $this = $(this);
    var type = $this.attr('data-type');
    var id = $this.attr('data-id');
    var path = "/course/learning/".concat(courseSlug, "/itemSequenceContentInfo?type=").concat(type, "&item=").concat(id);
    handleBasicModal(path, accessDeniedLang, function (result, $body, $footer) {
      var footerHtml = "<div class=\"\">\n                <h5 class=\"font-14 text-black\">".concat(noteLang, "</h5>\n                <p class=\"mt-4 font-12 text-gray-500\">").concat(accessDeniedModalFooterHintLang, "</p>\n            </div>");
      $footer.html(footerHtml);
    }, '', '37rem');
  });

  /************
   * Assignment Conversation
   * */
  $('body').on('click', '.js-send-assignment-conversation', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('.js-assignment-conversation-form');
    var path = $form.attr('data-action');
    handleSendRequestItemForm($form, $this, path);
  });
  $('body').on('click', '.js-show-submit-rate', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr('data-path');
    handleBasicModal(path, rateAssignmentLang, function (result, $body, $footer) {
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-between\">\n                <div class=\"\">\n                    <div class=\"font-weight-bold text-black\">".concat(result.pass_grade, "</div>\n                    <div class=\"mt-4 font-12 text-gray-500\">").concat(passGradeLang, "</div>\n                </div>\n                <button type=\"button\" class=\"js-submit-rate-btn btn btn-primary btn-lg\">").concat(submitGradeLang, "</button>\n            </div>");
      $footer.html(footerHtml);
    }, '', '37rem');
  });
  $('body').on('click', '.js-submit-rate-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $('.js-assigment-submit-grade-form');
    var path = $form.attr('data-action');
    handleSendRequestItemForm($form, $this, path);
  });

  /************
   * Forum
   * */
  $('body').on('click', '.js-forum-pin-toggle', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr('data-action');
    if ($this.hasClass('text-gray-500')) {
      $this.removeClass('text-gray-500').addClass('text-warning');
    } else {
      $this.removeClass('text-warning').addClass('text-gray-500');
    }
    $.post(path, {}, function (result) {
      if (result.code === 200) {
        showToast('success', result.title, result.msg);
      }
    }).fail(function () {
      showToast('error', oopsLang, somethingWentWrongLang);
    });
  });
  $('body').on('click', '.js-forum-question-action', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr('data-action');
    var title = $this.attr('data-title');
    handleBasicModal(path, title, function (result, $body, $footer) {
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-end\">\n\n                <button type=\"button\" class=\"js-submit-forum-question-btn btn btn-primary\">".concat(submitQuestionLang, "</button>\n            </div>");
      $footer.html(footerHtml);
    }, '', '37rem');
  });
  $('body').on('click', '.js-submit-forum-question-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $('.js-forum-question-form');
    var path = $form.attr('data-action');
    handleSendRequestItemForm($form, $this, path);
  });
  $('body').on('click', '.js-mark-as-resolved-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr('data-action');
    var title = $this.attr('data-title');
    var confirm = $this.attr('data-confirm');
    handleBasicModal(path, title, function (result, $body, $footer) {
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-end\">\n\n                <button type=\"button\" class=\"js-confirm-mark-as-resolved btn btn-primary\" data-action=\"".concat(path, "\">").concat(confirm, "</button>\n            </div>");
      $footer.html(footerHtml);
    }, '', '37rem');
  });
  $('body').on('click', '.js-confirm-mark-as-resolved', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr('data-action');
    $this.addClass('loadingbar').prop('disabled', true);
    $.post(path, {}, function (result) {
      if (result.code === 200) {
        showToast('success', result.title, result.msg);
        setTimeout(function () {
          window.location.reload();
        }, 1000);
      }
    }).fail(function () {
      showToast('error', oopsLang, somethingWentWrongLang);
    });
  });
  $('body').on('click', '.js-answer-action-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr('data-action');
    loadingSwl();
    var data = {};
    $.post(path, data, function (result) {
      if (result.code === 200) {
        var html = "<div class=\"d-flex-center flex-column text-center my-24\">\n                    <h4 class=\"font-14\">".concat(result.title, "</h4>\n                    <div class=\"mt-8 font-12 text-gray-500\">").concat(result.msg, "</div>\n                </div>");
        Swal.fire({
          html: html,
          showConfirmButton: false,
          icon: 'success'
        });
        setTimeout(function () {
          window.location.reload();
        }, 1000);
      }
    }).fail(function () {
      showToast('error', oopsLang, somethingWentWrongLang);
    });
  });
  $('body').on('click', '.js-reply-forum-question', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var path = $form.attr('action');
    handleSendRequestItemForm($form, $this, path);
  });
  $('body').on('click', '.js-edit-forum-answer', function (e) {
    e.preventDefault();
    var $this = $(this);
    var path = $this.attr('data-action');
    var title = $this.attr('data-title');
    var confirm = $this.attr('data-confirm');
    handleBasicModal(path, title, function (result, $body, $footer) {
      var footerHtml = "<div class=\"d-flex align-items-center justify-content-end\">\n\n                <button type=\"button\" class=\"js-submit-answer-update btn btn-primary\">".concat(confirm, "</button>\n            </div>");
      $footer.html(footerHtml);
    }, '', '37rem');
  });
  $('body').on('click', '.js-submit-answer-update', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $('.js-forum-answer-form');
    var path = $form.attr('data-action');
    handleSendRequestItemForm($form, $this, path);
  });
  $('body').on('click', '.js-toggle-show-learning-page-sidebar-drawer', function (e) {
    e.preventDefault();
    var $sidebar = $('#learningPageSidebar');
    $sidebar.toggleClass('show-drawer');
  });
})(jQuery);
/******/ })()
;