/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!****************************************************!*\
  !*** ./resources/js/design_1/parts/leaflet_map.js ***!
  \****************************************************/
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
(function () {
  "use strict";

  window.windowMapContainers = {};
  window.makeMapContainer = function (elId) {
    var _mapContainer$attr, _mapContainer$attr2, _mapContainer$attr3, _mapContainer$attr4;
    var storeDragMovement = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    var mapContainer = $('#' + elId);
    var lat = mapContainer.attr('data-latitude');
    var lng = mapContainer.attr('data-longitude');
    var zoom = mapContainer.attr('data-zoom');
    var maxZoom = (_mapContainer$attr = mapContainer.attr('data-max-zoom')) !== null && _mapContainer$attr !== void 0 ? _mapContainer$attr : 18;
    var dragging = !(mapContainer.attr('data-dragging') === 'false'); // if you want true, dont use data-dragging on tag
    var zoomControl = !(mapContainer.attr('data-zoomControl') === 'false');
    var zoomControlPosition = (_mapContainer$attr2 = mapContainer.attr('data-zoomControlPosition')) !== null && _mapContainer$attr2 !== void 0 ? _mapContainer$attr2 : 'topright';
    var scrollWheelZoom = !(mapContainer.attr('data-scrollWheelZoom') === 'false');
    var attribution = !(mapContainer.attr('data-attribution') === 'false');
    var fullscreen = (_mapContainer$attr3 = mapContainer.attr('data-fullscreen')) !== null && _mapContainer$attr3 !== void 0 ? _mapContainer$attr3 : false;
    var defaultMarker = (_mapContainer$attr4 = mapContainer.attr('data-default-marker')) !== null && _mapContainer$attr4 !== void 0 ? _mapContainer$attr4 : false;
    var mapOption = {
      dragging: dragging,
      zoomControl: false,
      scrollWheelZoom: scrollWheelZoom
    };
    var map = L.map(elId, mapOption).setView([lat, lng], zoom);
    L.tileLayer(leafletApiPath, {
      maxZoom: maxZoom,
      tileSize: 512,
      zoomOffset: -1,
      attribution: attribution ? '© <a target="_blank" rel="nofollow" href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>' : ''
    }).addTo(map);

    // add default marker
    if (defaultMarker) {
      var myIcon = L.icon({
        iconUrl: '/assets/default/images/location.png',
        iconAnchor: [lat, lng]
      });
      L.marker([lat, lng], {
        color: '#43d477',
        icon: myIcon
      }).addTo(map);
    }

    //add zoom control with your options
    if (zoomControl) {
      L.control.zoom({
        position: zoomControlPosition
      }).addTo(map);
    }

    // create a fullscreen button and add it to the map
    if (fullscreen) {
      L.control.fullscreen({
        position: 'topleft' // change the position of the button can be topleft, topright, bottomright or bottomleft, default topleft
        /*title: 'Show me the fullscreen !', // change the title of the button, default Full Screen
        titleCancel: 'Exit fullscreen mode', // change the title of the button when fullscreen is on, default Exit Full Screen
        content: null, // change the content of the button, can be HTML, default null
        forceSeparateButton: true, // force separate button to detach from zoom buttons, default false
        forcePseudoFullscreen: true, // force use of pseudo full screen even if full screen API is available, default false
        fullscreenElement: false // Dom element to render in full screen, false by default, fallback to map._container*/
      }).addTo(map);
    }
    if (storeDragMovement) {
      var $parent = mapContainer.parent();
      var LocationLatitude = $parent.find('#LocationLatitude');
      var LocationLongitude = $parent.find('#LocationLongitude');
      if (LocationLatitude.length && LocationLongitude.length) {
        map.on('moveend', function (e) {
          var centerLocation = map.getCenter();
          LocationLatitude.val(centerLocation.lat);
          LocationLongitude.val(centerLocation.lng);
        });
        map.on('dragstart', function () {
          $('.region-map .marker').addClass('dragging');
        });
        map.on('dragend', function () {
          $('.region-map .marker').removeClass('dragging');
        });
      }
    }
    windowMapContainers[elId] = map;
    return map;
  };
  function makeMapContainerForDrag($el) {
    var $parent = $el.parent();
  }
  $(document).ready(function () {
    function handleAddressMaps() {
      var mapCards = $('.region-map');
      if (mapCards.length > 0 && typeof makeMapContainer !== "undefined") {
        var _iterator = _createForOfIteratorHelper(mapCards),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var mapCard = _step.value;
            if ($(mapCard).hasClass('with-default-initial')) {
              makeMapContainer($(mapCard).attr('id'));
            } else if ($(mapCard).hasClass('with-default-initial-drag')) {
              makeMapContainer($(mapCard).attr('id'), true);
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
      }
    }
    handleAddressMaps();
  });
  window.resetAddressMaps = function (mapCards) {
    if (mapCards.length > 0 && typeof makeMapContainer !== "undefined") {
      var _iterator2 = _createForOfIteratorHelper(mapCards),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var mapCard = _step2.value;
          var elId = $(mapCard).attr('id');
          if (typeof windowMapContainers !== "undefined" && typeof windowMapContainers[elId] !== "undefined") {
            windowMapContainers[elId].off();
            windowMapContainers[elId].remove();
          }
          if ($(mapCard).hasClass('with-default-initial')) {
            makeMapContainer(elId);
          } else if ($(mapCard).hasClass('with-default-initial-drag')) {
            makeMapContainer(elId, true);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  };
})(jQuery);
/******/ })()
;