/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*****************************************************************!*\
  !*** ./resources/js/design_1/parts/instructor_finder_wizard.js ***!
  \*****************************************************************/
(function ($) {
  "use strict";

  $('body').on('change', 'input[name="meeting_type"]', function () {
    var regionCard = $('#regionCard');
    if ($(this).val() === 'online') {
      regionCard.addClass('d-none');
    } else {
      regionCard.removeClass('d-none');
    }
  });
  $('body').on('change', 'input[name="flexible_date"]', function () {
    if (this.checked) {
      $('#dateTimeCard').addClass('d-none');
    } else {
      $('#dateTimeCard').removeClass('d-none');
    }
  });
  $('body').on('click', '.js-next-btn', function (e) {
    e.preventDefault();
    $(this).addClass('loadingbar').prop('disabled', true);
    $('#instructorFinderWizardForm').trigger('submit');
  });
  $('body').on('click', '.js-previous-btn', function (e) {
    e.preventDefault();
    $(this).addClass('loadingbar').prop('disabled', true);
    var $form = $('#instructorFinderWizardForm');
    var $stepInput = $form.find('input[name="step"]');
    var nextStep = $stepInput.val();
    $stepInput.val(nextStep - 2);
    $form.trigger('submit');
  });
  $(document).ready(function () {
    var $timeRange = $('#timeRange');
    if ($timeRange && $timeRange.length && jQuery().wRunner) {
      var minLimit = $timeRange.attr('data-minLimit');
      var maxLimit = $timeRange.attr('data-maxLimit');
      var minTimeEl = $timeRange.find('input[name="min_time"]');
      var maxTimeEl = $timeRange.find('input[name="max_time"]');
      var minValue = minTimeEl.val();
      var maxValue = maxTimeEl.val();
      var wtime = $timeRange.wRunner({
        type: 'range',
        limits: {
          minLimit: minLimit,
          maxLimit: maxLimit
        },
        rangeValue: {
          minValue: minValue,
          maxValue: maxValue
        },
        step: 1
      });
      wtime.onValueUpdate(function (values) {
        minTimeEl.val(values.minValue);
        maxTimeEl.val(values.maxValue);
      });
    }
  });
})(jQuery);
/******/ })()
;