/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*****************************************************!*\
  !*** ./resources/js/design_1/parts/auth_theme_1.js ***!
  \*****************************************************/
(function ($) {
  "use strict";

  var canResendCode = "ok";
  function handleResendTimer() {
    var $timer = $('.js-resend-timer');
    if (jQuery().startTimer && $timer.length) {
      canResendCode = "wait";
      $timer.html("");
      var $resendDurationCard = $('.js-resend-duration-card');
      var $dontReceivedCard = $('.js-dont-received-card');
      var $resendBtn = $('.js-resend-code-btn');
      $resendBtn.removeClass('text-black').addClass('text-gray-500');
      $resendDurationCard.addClass('d-flex').removeClass('d-none');
      $dontReceivedCard.addClass('d-none');
      $timer.startTimer({
        onComplete: function onComplete(element) {
          $resendBtn.removeClass('text-gray-500').addClass('text-black');
          $resendDurationCard.removeClass('d-flex').addClass('d-none');
          $dontReceivedCard.removeClass('d-none');
          canResendCode = "ok";
        }
      });
    }
  }
  $(document).ready(function () {
    var _$countryCodeSelect2$;
    var $countryCodeSelect2 = $('.country-code-select2');
    var dropdownParent = (_$countryCodeSelect2$ = $countryCodeSelect2.attr('data-dropdown-parent')) !== null && _$countryCodeSelect2$ !== void 0 ? _$countryCodeSelect2$ : 'body';
    $countryCodeSelect2.select2({
      dropdownCssClass: "country-code-select2-dropdown",
      dropdownParent: $(dropdownParent)
    });
    handleResendTimer();
  });
  $('body').on('change', 'input[name="type"]', function () {
    var val = $(this).val();
    var $email = $('.js-email-fields');
    var $mobile = $('.js-mobile-fields');
    $mobile.addClass('d-none');
    $email.addClass('d-none');
    if (val === "email") {
      $email.removeClass('d-none');
    } else {
      $mobile.removeClass('d-none');
    }
  });
  $('body').on('click', '.password-input-visibility', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $eye = $this.find('.icons-eye');
    var $eyeSlash = $this.find('.icons-eye-slash');
    var $input = $this.closest('.form-group').find('input');
    var isHide = $input.attr('type') === "password";
    if (isHide) {
      $input.attr("type", "text");
      $eye.addClass('d-none');
      $eyeSlash.removeClass('d-none');
    } else {
      $input.attr("type", "password");
      $eye.removeClass('d-none');
      $eyeSlash.addClass('d-none');
    }
  });

  /*==================
  * Verification
  * **************/

  $('body').on('input', '.auth-verification-code-field', function (e) {
    var $this = $(this);
    var value = $this.val();
    if (value.length > 1) {
      $this.val(value.charAt(0)); // Trim to a single digit
    }

    if (value.length === 1) {
      $this.next('.auth-verification-code-field').focus();
    }
  });
  $('body').on('keydown', '.auth-verification-code-field', function (e) {
    var $this = $(this);
    if (e.key === "Backspace" && $this.val() === '') {
      $this.prev('.auth-verification-code-field').focus();
    }
  });
  $('body').on('click', '.js-resend-code-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    if (canResendCode === "ok") {
      var $submitBtn = $('.js-submit-verification-form-btn');
      $submitBtn.addClass('loadingbar').prop('disabled', true);
      $this.prop('disabled', true);
      var path = "/verification/resend";
      $.get(path, function (result) {
        if (result.code === 200) {
          showToast('success', result.title, result.msg);
          $('.auth-verification-code-field').val('');
          handleResendTimer();
        }
      }).fail(function (err) {
        showToast('error', oopsLang, somethingWentWrongLang);
      }).always(function () {
        $submitBtn.removeClass('loadingbar').prop('disabled', false);
        $this.prop('disabled', false);
      });
    } else {
      showToast("error", waitLang, pleaseWaitUntilTimeOverLang);
    }
  });
  $('body').on('click', '.js-submit-verification-form-btn', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    $this.addClass('loadingbar');
    $form.trigger('submit');
  });

  /*==================
  * Register
  * **************/

  $('body').on('change', 'input[name="account_type"]', function () {
    var value = $(this).val();
    $.post('/register/form-fields', {
      type: value
    }, function (result) {
      if (result) {
        $('.js-form-fields-card').html(result.html);
        formsDatetimepicker();
      }
    });
  });
})(jQuery);
/******/ })()
;