/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!*******************************************************!*\
  !*** ./resources/js/admin/parts/course_statistics.js ***!
  \*******************************************************/
(function ($) {
  "use strict";

  var style = getComputedStyle(document.body);
  var primaryColor = style.getPropertyValue('--primary');
  var secondaryColor = style.getPropertyValue('--secondary');
  var warningColor = style.getPropertyValue('--warning');
  function hexToRgb(hex) {
    var rgba = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    var rgb = '';
    if (result) {
      rgb = "rgb(".concat(parseInt(result[1], 16), ",").concat(parseInt(result[2], 16), ",").concat(parseInt(result[3], 16), ")");
      if (rgba) {
        rgb = "rgba(".concat(parseInt(result[1], 16), ",").concat(parseInt(result[2], 16), ",").concat(parseInt(result[3], 16), ", ").concat(rgba, ")");
      }
    }
    return rgb;
  }
  function pieChart($el, labels, datasets) {
    new Chart($el, {
      type: 'doughnut',
      data: {
        labels: labels,
        datasets: [{
          label: '',
          data: datasets,
          borderWidth: 0,
          borderColor: '',
          backgroundColor: [primaryColor, secondaryColor, warningColor],
          pointBackgroundColor: '#fff',
          pointBorderColor: '#6777ef',
          pointRadius: 4,
          fill: true
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        segmentShowStroke: false,
        legend: {
          display: false
        }
      }
    });
  }
  window.makePieChart = function (elId, labels, datasets) {
    var bodyEl = document.getElementById(elId).getContext('2d');
    pieChart(bodyEl, labels, datasets);
  };
  window.handleMonthlySalesChart = function (labels, datasets) {
    var ctx = document.getElementById('monthlySalesChart').getContext('2d');
    new Chart(ctx, {
      type: 'line',
      data: {
        labels: labels,
        datasets: [{
          label: '',
          data: datasets,
          backgroundColor: 'transparent',
          borderColor: primaryColor,
          borderWidth: 2
        }]
      },
      options: {
        responsive: true,
        legend: {
          display: false
        }
      }
    });
  };
  window.handleCourseProgressChart = function (labels, datasets) {
    var ctx = document.getElementById('courseProgressLineChart').getContext('2d');
    new Chart(ctx, {
      type: 'bar',
      data: {
        labels: labels,
        datasets: [{
          label: '',
          data: datasets,
          backgroundColor: hexToRgb(primaryColor, 0.4),
          borderColor: primaryColor,
          borderWidth: 2
        }]
      },
      options: {
        responsive: true,
        legend: {
          display: false
        }
      }
    });
  };
})(jQuery);
/******/ })()
;