/******/ (() => { // webpackBootstrap
var __webpack_exports__ = {};
/*!**********************************************************!*\
  !*** ./resources/js/admin/parts/course-forum-answers.js ***!
  \**********************************************************/
(function ($) {
  "use strict";

  $('body').on('click', '.js-answer-edit', function (e) {
    e.preventDefault();
    var $this = $(this);
    var action = $this.attr('data-action');
    loadingSwl();
    $.get(action, function (result) {
      if (result && result.code === 200) {
        var post = result.post;
        var random = randomString();
        var html = makeEditPostHtml(post, action, random);
        Swal.fire({
          html: html,
          showConfirmButton: false,
          width: '60rem'
        });
      } else {
        Swal.fire(oopsLang, somethingWentWrongLang, 'error');
      }
    }).fail(function (err) {
      Swal.fire(oopsLang, somethingWentWrongLang, 'error');
    });
  });
  $('body').on('click', '.js-save-post', function (e) {
    e.preventDefault();
    var $this = $(this);
    var $form = $this.closest('form');
    var action = $form.attr('action');
    var data = $form.serializeObject();
    $this.addClass('loadingbar primary').prop('disabled', true);
    $form.find('.invalid-feedback').text('');
    $form.find('.is-invalid').removeClass('is-invalid');
    $.post(action, data, function (result) {
      if (result && result.code === 200) {
        Swal.fire({
          icon: 'success',
          html: '<h3 class="font-20 text-center text-dark-blue">' + savedSuccessfullyLang + '</h3>',
          showConfirmButton: false
        });
        setTimeout(function () {
          window.location.reload();
        }, 500);
      }
      $this.removeClass('loadingbar primary').prop('disabled', false);
    }).fail(function (err) {
      $this.removeClass('loadingbar primary').prop('disabled', false);
      var errors = err.responseJSON;
      if (errors && errors.errors) {
        Object.keys(errors.errors).forEach(function (key) {
          var error = errors.errors[key];
          var element = $form.find('[name="' + key + '"]');
          element.addClass('is-invalid');
          element.parent().find('.invalid-feedback').text(error[0]);
        });
      }
    });
  });
  function makeEditPostHtml(post, action, record) {
    var _post$attach;
    return "<div>\n        <h3 class=\"section-title after-line font-20 text-dark-blue\">".concat(editPostLang, "</h3>\n\n        <form action=\"").concat(action, "\" method=\"post\" class=\"mt-25\">\n\n            ").concat(typeof post.title !== "undefined" ? "\n                    <div class=\"form-group text-left\">\n                        <label class=\"input-label\">".concat(titleLang, "</label>\n                        <input name=\"title\" class=\"form-control\" value=\"").concat(post.title, "\"/>\n                        <div class=\"invalid-feedback\"></div>\n                    </div>\n                ") : '', "\n\n            <div class=\"form-group text-left\">\n                <label class=\"input-label\">").concat(descriptionLang, "</label>\n                <textarea name=\"description\" rows=\"5\" class=\"form-control\">").concat(post.description, "</textarea>\n                <div class=\"invalid-feedback\"></div>\n            </div>\n\n            ").concat(typeof post.attach !== "undefined" ? "<div class=\"row\">\n                    <div class=\"col-12 col-md-7\">\n                        <div class=\"form-group text-left\">\n                            <label class=\"input-label\">".concat(editAttachmentLabelLang, "</label>\n\n                            <div class=\"d-flex align-items-center\">\n                                <div class=\"input-group mr-10\">\n                                    <div class=\"input-group-prepend\">\n                                        <button type=\"button\" class=\"input-group-text admin-file-manager\" data-input=\"postAttachmentInput_").concat(record, "\" data-preview=\"holder\">\n                                            <i class=\"fa fa-upload\"></i>\n                                        </button>\n                                    </div>\n                                    <input type=\"text\" name=\"attach\" id=\"postAttachmentInput_").concat(record, "\" value=\"").concat((_post$attach = post.attach) !== null && _post$attach !== void 0 ? _post$attach : '', "\" class=\"form-control\"/>\n                                </div>\n                            </div>\n                        </div>\n                    </div>\n                </div>") : '', "\n\n            <div class=\"text-left\">\n                <button type=\"button\" class=\"js-save-post btn btn-primary btn-sm mt-2\">").concat(sendLang, "</button>\n            </div>\n        </form>\n    </div>");
  }
})(jQuery);
/******/ })()
;