<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('landing_builder_components', function (Blueprint $table) {
            $table->increments('id');
            $table->string('name')->unique();
            $table->enum('category', \App\Enums\LandingBuilderComponentCategories::getAll());
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('landing_builder_components');
    }
};
